// Great Triambic Icosidodecahedron
// POV-Ray source Copyright 2002 by Mark Newbold
// All rights reserved.

// Render with a square resolution (width equal to height)
// A resolution of 2384x2384 will duplicate the image size of the quilt pattern that we used.

#include "colors.inc"

global_settings { ambient_light rgb 5 }


camera {
  location <0, 0, -20.66 >  // 2.066 is the size in the hyperstar applet, times 10 to give the correct perspective
  up <0,1,0>
  right x
  direction 2.333*4.45*z
  look_at 0
}

background { color rgb .75 }

// You can move the light source around to give different shadows
light_source{ 1000*x +1000*y -1100*z White*1.2 }

// Including the "shadowless" keyword eliminates the shadows
//light_source{ 1000*x +1000*y -1100*z White*1.2 shadowless }

#include "POLYHED1.INC"

union {
  object {
   pent
   pigment { color rgb < 184, 137, 196 >/256 }
   transform D0
  }
  object {
   pent
   pigment { color rgb < 173,  29,  24 >/256 }
   transform D1
  }
  object {
   pent
   pigment { color rgb <  56,  36,  98 >/256 }
   transform D2
  }
  object {
   pent
   pigment { color rgb <  81,  62, 150 >/256 }
   transform D3
  }
  object {
   pent
   pigment { color rgb < 179, 186, 150 >/256 }
   transform D4
  }
  object {
   pent
   pigment { color rgb < 227, 190, 140 >/256 }
   transform D5
  }
  object {
   pent
   transform D6
  }
  object {
   pent
   transform D7
  }
  object {
   pent
   transform D8
  }
  object {
   pent
   transform D9
  }
  object {
   pent
   transform D10
  }
  object {
   pent
   transform D11
  }
  
  
  
  object {
   tri
   pigment { color rgb < 123, 23, 56 >/256 }
   transform I0
  }
  object {
   tri
   pigment { color rgb < 147, 141, 178 >/256 }
   transform I1
  }
  object {
   tri
   pigment { color rgb < 238, 155, 51 >/256 }
   transform I2
  }
  object {
   tri
   pigment { color rgb < 188, 193, 213 >/256 }
   transform I3
  }
  object {
   tri
   pigment { color rgb < 36, 17, 25 >/256 }
   transform I4
  }
  object {
   tri
   pigment { color rgb < 140, 34, 26 >/256 }
   transform I5
  }
  object {
   tri
   pigment { color rgb < 224, 208, 183 >/256 }
   transform I6
  }
  object {
   tri
   pigment { color rgb < 151, 154, 139 >/256 }
   transform I7
  }
  object {
   tri
   transform I8
  }
  object {
   tri
   transform I9
  }
  object {
   tri
   pigment { color rgb < 94, 161, 178 >/256 }
   transform I10
  }
  object {
   tri
   transform I11
  }
  object {
   tri
   transform I12
  }
  object {
   tri
   pigment { color rgb < 172, 178, 149 >/256 }
   transform I13
  }
  object {
   tri
   transform I14
  }
  object {
   tri
   transform I15
  }
  object {
   tri
   transform I16
  }
  object {
   tri
   transform I17
  }
  object {
   tri
   transform I18
  }
  object {
   tri
   transform I19
  }

  // This matrix reverses front and back  
  matrix
    <
      1.0, 0.0,  0.0,
      0.0, 1.0,  0.0,
      0.0, 0.0, -1.0,
      0.0, 0.0,  0.0 >
      
  rotate < 0, 0, 180>
  
  
  scale 1.0
}

